<?php

namespace App\Filament\Admin\Resources\Customers\Schemas;

use Filament\Infolists\Components\TextEntry;
use Filament\Schemas\Schema;
use Filament\Schemas\Components\Section;
use Filament\Schemas\Components\Grid;
use Filament\Infolists\Components\RepeatableEntry;

class CustomerInfolist
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                Section::make('Data Customer')
                    ->schema([
                        Grid::make(2)->schema([
                            TextEntry::make('name')->label('Nama Customer'),
                            TextEntry::make('no_po')->label('Nomor PO')->placeholder('-'),
                            // TextEntry::make('date_of_po')->label('Tanggal PO')->placeholder('-')
                        ])
                    ])
                    ->columnSpanFull(), 
                Section::make('Data Riwayat')
                    ->schema([  
                        RepeatableEntry::make('repairInspections')
                            ->label('Riwayat')
                            ->schema([
                                Grid::make(3)->schema([
                                    TextEntry::make('serial_number_unit_gas_detector')->label('Serial Number Unit'),
                                    TextEntry::make('unit.name')->label('Unit'),
                                    TextEntry::make('number_certificate')->label('No. Sertifikat'),
                                ]),
                                Grid::make(4)->schema([
                                    TextEntry::make('date_of_entry')->label('Tanggal Masuk')->formatStateUsing(fn($state)=> $state ? \Carbon\Carbon::parse($state)->format('d-m-Y') : '-'),
                                    TextEntry::make('date_of_exit')->label('Tanggal Keluar')->formatStateUsing(fn($state)=> $state ? \Carbon\Carbon::parse($state)->format('d-m-Y') : '-'),
                                    TextEntry::make('status')->label('Status')->badge()
                                        ->color(fn($state) => $state === 'success' ? 'success' : ($state === 'warning' ? 'warning' : ($state === 'cancel' ? 'danger' : ($state === 'off' ? 'gray' : 'gray')))),
                                    TextEntry::make('edit')
                                        ->label('Aksi')
                                        ->state(fn($record) => 'Edit')
                                        ->url(fn($record) => route('filament.admin.resources.repair-inspections.edit', $record->id))
                                        ->openUrlInNewTab()
                                        ->color('primary')
                                        ->icon('heroicon-s-pencil')
                                        ->size('xl')
                                        ->badge(),
                                ]),
                            ])
                    ])
                    ->columnSpanFull(),
            ]);
    }
}
