<?php

namespace App\Filament\Admin\Resources\RepairInspections\Pages;

use App\Filament\Admin\Resources\RepairInspections\RepairInspectionResource;
use App\Models\FirmWire;
use Filament\Resources\Pages\CreateRecord;

class CreateRepairInspection extends CreateRecord
{
    protected static string $resource = RepairInspectionResource::class;

    protected function mutateFormDataBeforeCreate(array $data): array
    {
        // Save to firm_wires table if data exists
        if (!empty($data['type_firm_wire'])) {
            FirmWire::firstOrCreate(
                ['name' => trim($data['type_firm_wire'])],
                ['name' => trim($data['type_firm_wire'])]
            );
        }

        return $data;
    }
}
