<?php

namespace App\Filament\Admin\Resources\RepairInspections\Pages;

use App\Filament\Admin\Resources\RepairInspections\RepairInspectionResource;
use App\Models\FirmWire;
use Filament\Actions\DeleteAction;
use Filament\Actions\ViewAction;
use Filament\Notifications\Notification;
use Filament\Resources\Pages\EditRecord;
use Illuminate\Support\Facades\Auth;

class EditRepairInspection extends EditRecord
{
    protected static string $resource = RepairInspectionResource::class;

    protected function getHeaderActions(): array
    {
        return [
            ViewAction::make(),
            DeleteAction::make(),
        ];
    }

    protected function mutateFormDataBeforeSave(array $data): array
    {
        // Save to firm_wires table if data exists
        if (!empty($data['type_firm_wire'])) {
            FirmWire::firstOrCreate(
                ['name' => trim($data['type_firm_wire'])],
                ['name' => trim($data['type_firm_wire'])]
            );
        }

        return $data;
    }
}
