<?php

namespace App\Filament\Admin\Resources\RepairInspections;

use App\Filament\Admin\Resources\RepairInspections\Pages\CreateRepairInspection;
use App\Filament\Admin\Resources\RepairInspections\Pages\EditRepairInspection;
use App\Filament\Admin\Resources\RepairInspections\Pages\ListRepairInspections;
use App\Filament\Admin\Resources\RepairInspections\Schemas\RepairInspectionForm;
use App\Filament\Admin\Resources\RepairInspections\Schemas\RepairInspectionInfolist;
use App\Filament\Admin\Resources\RepairInspections\Tables\RepairInspectionsTable;
use App\Models\RepairInspection;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;

class RepairInspectionResource extends Resource
{
    protected static ?string $model = RepairInspection::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::DocumentText;

    public static function getNavigationGroup(): string
    {
        return 'Repair & Inspection';
    }

    public static function getNavigationBadge(): ?string
    {
        return static::getModel()::count();
    }

    public static function form(Schema $schema): Schema
    {
        return RepairInspectionForm::configure($schema);
    }

    public static function infolist(Schema $schema): Schema
    {
        return RepairInspectionInfolist::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return RepairInspectionsTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListRepairInspections::route('/'),
            'create' => CreateRepairInspection::route('/create'),
            // 'view' => ViewRepairInspection::route('/{record}'),
            'edit' => EditRepairInspection::route('/{record}/edit'),
        ];
    }
}
