<?php

namespace App\Filament\Admin\Resources\RepairInspections\Schemas;

use Filament\Infolists\Components\ImageEntry;
use Filament\Infolists\Components\TextEntry;
use Filament\Schemas\Components\Grid;
use Filament\Schemas\Components\Section;
use Filament\Schemas\Schema;

class RepairInspectionInfolist
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                Section::make('Unit')
                    ->schema([
                        Grid::make([
                            'default' => 2,
                            'md' => 2,
                        ])->schema([
                            TextEntry::make('unit.name')
                                ->label('Unit')
                                ->placeholder('-'),
                            TextEntry::make('serial_number_unit_gas_detector')
                                ->label('Serial Number Unit')
                                ->placeholder('-'),
                            TextEntry::make('type_firm_wire')
                                ->label('Tipe Firm Wire')
                                ->placeholder('-'),
                            TextEntry::make('date_of_purchase')
                                ->label('Tahun PO')
                                ->placeholder('-'),
                           
                            TextEntry::make('status')
                                ->badge()
                                ->label('Status')
                                ->color(fn ($state) => (
                                    $state == 'success' ? 'success'
                                    : ($state == 'warning' ? 'warning'
                                    : ($state == 'cancel' ? 'danger'
                                    : ($state == 'off' ? 'gray'
                                    : 'gray')))
                                ))
                                ->placeholder('-'),
                                TextEntry::make('no_po')
                                ->label('No PO')
                                ->placeholder('-'),
                            ImageEntry::make('image')
                                ->height(200)
                                ->label('Image Condition')
                                ->disk('public')
                                ->placeholder('-'),
                            TextEntry::make('comment')
                                ->label('Catatan')
                                ->placeholder('-')
                                ->formatStateUsing(fn ($state) =>
                                    blank(strip_tags($state))
                                        ? '-'
                                        : strip_tags($state)
                                )
                                ->columnSpan(['md' => 2]),
                        ]),
                    ]),
                    
                Section::make('Tanggal')
                    ->schema([
                        Grid::make([
                            'default' => 2,
                            'md' => 2,
                        ])->schema([
                            TextEntry::make('date_of_entry')
                                ->label('Tanggal Masuk')    
                                ->formatStateUsing(fn ($state) => blank($state)
                                    ? null
                                    : \Carbon\Carbon::parse($state)
                                        ->locale('id')
                                        ->translatedFormat('d F Y')
                                )
                                ->placeholder('-'),
                            TextEntry::make('mounth_of_entry')
                                ->label('Bulan Masuk')
                                ->formatStateUsing(fn ($state) => blank($state) ? null : ucfirst($state))
                                ->placeholder('-'),
                            TextEntry::make('date_of_exit')
                                ->label('Tanggal Keluar')
                                ->formatStateUsing(fn ($state) => blank($state)
                                    ? null
                                    : \Carbon\Carbon::parse($state)
                                        ->locale('id')
                                        ->translatedFormat('d F Y')
                                )
                                ->placeholder('-'),
                            TextEntry::make('mounth_of_exit')
                                ->label('Bulan Keluar')
                                ->formatStateUsing(fn ($state) => blank($state) ? null : ucfirst($state))
                                ->placeholder('-'),
                        ]),
                    ]),

                Section::make('Customer & Garansi')
                    ->schema([
                        Grid::make([
                            'default' => 2,
                            'md' => 2,
                        ])->schema([
                            TextEntry::make('customer.name')
                                ->label('Customer')
                                ->placeholder('-'),
                            TextEntry::make('warranty_start_date')
                                ->label('Tanggal Mulai Garansi')
                                ->formatStateUsing(fn ($state) => blank($state)
                                    ? null
                                    : \Carbon\Carbon::parse($state)
                                        ->locale('id')
                                        ->translatedFormat('d F Y')
                                )
                                ->placeholder('-'),
                            TextEntry::make('warranty_end_date')
                                ->label('Tanggal Akhir Garansi')
                                ->formatStateUsing(fn ($state) => blank($state)
                                    ? null
                                    : \Carbon\Carbon::parse($state)
                                        ->locale('id')
                                        ->translatedFormat('d F Y')
                                )
                                ->placeholder('-'),
                            TextEntry::make('so')
                                ->label('SO#')
                                ->placeholder('-'),
                            TextEntry::make('warranty_claim')
                                ->label('Klaim Garansi')
                                ->placeholder('-'),
                            TextEntry::make('number_certificate')
                                ->label('No. Sertifikat')
                                ->placeholder('-'),
                            TextEntry::make('reminder_period')
                                ->label('Masa Kalibrasi')
                                ->placeholder('-'),
                            TextEntry::make('status_penawaran')
                                ->label('Status Penawaran')
                                ->placeholder('-'),
                        ]),
                    ])->columnSpanFull(),

                Section::make('Serial Number Komponen')
                    ->schema([
                        Grid::make([
                            'default' => 2,
                            'md' => 2,
                        ])->schema([
                            TextEntry::make('old_serial_number_censor')->label('Sensor (Lama)')->placeholder('-'),
                            TextEntry::make('new_serial_number_censor')->label('Sensor (Baru)')->placeholder('-'),
                            TextEntry::make('old_serial_number_pcb')->label('PCB (Lama)')->placeholder('-'),
                            TextEntry::make('new_serial_number_pcb')->label('PCB (Baru)')->placeholder('-'),
                            TextEntry::make('old_serial_number_battery')->label('Baterai (Lama)')->placeholder('-'),
                            TextEntry::make('new_serial_number_battery')->label('Baterai (Baru)')->placeholder('-'),
                        ]),
                    ])->columnSpanFull(),
                
                // Section::make('Status')
                //     ->schema([
                //     ]),

                // TextEntry::make('created_at')
                //     ->dateTime()
                //     ->placeholder('-'),
                // TextEntry::make('updated_at')
                //     ->dateTime()
                //     ->placeholder('-'),
            ]);
    }
}
