<?php

namespace App\Filament\Admin\Resources\RepairInspections\Tables;

use App\Filament\Exports\RepairInspectionExporter;
use App\Filament\Imports\RepairInspectionImporter;
use Filament\Actions\Action;
use Filament\Actions\ActionGroup;
use Filament\Actions\BulkActionGroup;
use Filament\Actions\DeleteAction;
use Filament\Actions\DeleteBulkAction;
use Filament\Actions\EditAction;
use Filament\Actions\ExportAction;
use Filament\Actions\ImportAction;
use Filament\Actions\ViewAction;
use Filament\Tables\Filters\Filter;
use Filament\Forms\Components\Select;
use Illuminate\Database\Eloquent\Builder;
use Filament\Forms\Components\ToggleButtons;
use Filament\Support\Enums\Size;
use Filament\Tables\Columns\TextColumn;

use Filament\Tables\Filters\SelectFilter;
use Filament\Tables\Table;

class RepairInspectionsTable
{
    public static function configure(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('date_of_entry')
                    ->label('Tanggal Masuk')
                    ->formatStateUsing(fn ($state) =>
                        \Carbon\Carbon::parse($state)
                            ->locale('id')
                            ->translatedFormat('d F Y')
                    )
                    ->sortable(),
                // TextColumn::make('mounth_of_entry')
                //     ->label('Mounth of Entry Goods')
                //     ->date('F')
                //     ->sortable(),
               TextColumn::make('date_of_exit')
                    ->label('Tanggal Keluar')
                    ->formatStateUsing(fn ($state) =>
                        \Carbon\Carbon::parse($state)
                            ->locale('id')
                            ->translatedFormat('d F Y')
                    )
                    ->sortable(),
                TextColumn::make('status')
                    ->badge()
                    ->color(fn (string $state): string => match ($state) {
                        'success' => 'success',
                        'warning' => 'warning', 
                        'cancel' => 'danger',
                        default => 'gray',
                    })
                    ->formatStateUsing(fn (string $state): string => match ($state) {
                        'success' => 'Success',
                        'warning' => 'Warning',
                        'cancel' => 'Cancel',
                        'pending' => 'Pending',
                        default => 'Off',
                    }),
                TextColumn::make('no_po')
                    ->label('No PO')
                    ->searchable(),
                // TextColumn::make('mounth_of_exit')
                //     ->label('Mounth of Out Goods')
                //     ->date('F')
                //     ->sortable(),
                // TextColumn::make('unit.name')
                //     ->label('Unit')
                //     ->numeric(),
                TextColumn::make('serial_number_unit_gas_detector')
                    ->label('Serial Number')
                    ->searchable(),
                // TextColumn::make('type_firm_wire')
                //     ->label('Type Firm Wire')
                //     ->searchable(),
                // TextColumn::make('old_serial_number_censor')
                //     ->searchable(),
                // TextColumn::make('new_serial_number_censor')
                //     ->searchable(),
                // TextColumn::make('old_serial_number_pcb')
                //     ->searchable(),
                // TextColumn::make('new_serial_number_pcb')
                //     ->searchable(),
                // TextColumn::make('old_serial_number_battery')
                //     ->searchable(),
                // TextColumn::make('new_serial_number_battery')
                //     ->searchable(),
                // TextColumn::make('date_of_purchase')
                //     ->date()
                //     ->searchable(),
                TextColumn::make('customer.name')
                    ->label('Customer')
                    ->formatStateUsing(fn ($state, $record) => $record->customer?->name)
                    ->numeric(),
                // TextColumn::make('warranty_start_date')
                //     ->date()
                //     ->searchable(),
                // TextColumn::make('warranty_end_date')
                //     ->searchable(),
                // TextColumn::make('so')
                //     ->label('SO#')
                //     ->searchable(),
                // TextColumn::make('warranty_claim')
                //     ->label('Warranty Claim')
                //     ->searchable(),
                // TextColumn::make('number_certificate')
                //     ->label('Number Certificate')
                //     ->searchable(),
                // TextColumn::make('comment')
                //     ->searchable(),
                // TextColumn::make('status_penawaran')
                //     ->searchable(),
                // TextColumn::make('created_at')
                //     ->dateTime()
                //     ->sortable()
                //     ->toggleable(isToggledHiddenByDefault: true),
                // TextColumn::make('updated_at')
                //     ->dateTime()
                //     ->sortable()
                //     ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->recordClasses(fn ($record) => match ($record->status) {
                'success' => 'bg-green-50 dark:bg-green-900/20',
                'warning' => 'bg-yellow-50 dark:bg-yellow-900/20',
                'cancel' => 'bg-red-50 dark:bg-red-900/20',
                default => null,
            })
            ->filters([
                SelectFilter::make('status')
                    ->options([
                        'success' => 'Success',
                        'warning' => 'Warning',
                        'cancel' => 'Cancel',
                        'off' => "Off",
                        'pending' => 'Pending'
                    ])
                    ->placeholder('Status Repair Inspections')
                    ->multiple(),
             ])
             ->recordActions([
                Action::make('status')
                    ->label(fn ($record): string => match ($record->status) {
                        'success' => 'Success',
                        'warning' => 'Warning',
                        'cancel' => 'Cancel',
                        'off' => 'Off',
                        'pending' => 'Pending',
                        default => 'Set Status',
                    })
                    ->color(fn ($record): string => match ($record->status) {
                        'success' => 'success',
                        'warning' => 'warning',
                        'cancel' => 'danger',
                        'off' => 'gray',
                        'pending' => 'gray',
                        default => 'gray',
                    })
                    ->form([
                        ToggleButtons::make('status')
                            ->options([
                                'success' => 'Success',
                                'warning' => 'Warning',
                                'cancel' => 'Cancel',
                                'off' => 'Off',
                                'pending' => 'Pending',
                            ])
                            ->colors([
                                'success' => 'success',
                                'warning' => 'warning',
                                'cancel' => 'danger',
                                'off' => 'gray',
                                'pending' => 'gray',
                            ])
                            ->inline()
                            ->required(),
                    ])
                    ->action(function (array $data, $record): void {
                        $record->update([
                            'status' => $data['status'],
                        ]);
                    })
                    ->fillForm(fn ($record): array => [
                        'status' => $record->status,
                ])->label('Status')
                    ->size(Size::Small)
                    ->color('primary')
                    ->button(),
                ActionGroup::make([
                    ViewAction::make(),
                    EditAction::make(),
                    DeleteAction::make(),
                    // PDF Action
                    Action::make('pdf')
                        ->label('PDF')
                        ->icon('heroicon-m-printer')
                        ->color('primary')
                        ->url(fn ($record) => route('repair-inspections.pdf', $record))
                        ->openUrlInNewTab(),
                ])->label('Actions')
                    ->icon('heroicon-m-ellipsis-vertical')  
                    ->size(Size::Small)
                    ->color('primary')
                    ->button()
            ])
            ->headerActions([
                ImportAction::make()
                    ->label('Import')
                    ->icon('heroicon-m-arrow-up-tray')
                    ->color('danger')
                    ->importer(RepairInspectionImporter::class),
                ExportAction::make()
                    ->label('Export')
                    ->icon('heroicon-m-arrow-down-tray')
                    ->color('primary')
                    ->exporter(RepairInspectionExporter::class),
            ])
            ->defaultSort('updated_at', 'desc')
            ->toolbarActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make(),
                ]),
            ]);
    }
}
