<?php

namespace App\Filament\Admin\Widgets;

use App\Models\RepairInspection;
use Filament\Widgets\ChartWidget;
use Illuminate\Support\Facades\DB;

class XDashboardChart extends ChartWidget
{
    protected ?string $heading = 'Status Chart History Customer';

    protected function getData(): array
    {
        $counts = RepairInspection::select("status", DB::raw("COUNT(*) as total"))
            ->groupBy("status")
            ->pluck('total', 'status');;

        $data = [
            "success" => $counts->get("success", 0),
            "warning" => $counts->get("warning", 0), 
            "cancel" => $counts->get("cancel", 0),
            "off" => $counts->get("off", 0),
            "pending" => $counts->get("pending", 0),
        ];

        return [
            'datasets' => [
                [
                    'label' => 'Status',
                    'data' => array_values($data),
                    'backgroundColor' => [
                        '#22c55e', 
                        '#facc15', 
                        '#ef4444', 
                        '#eaeaea',
                        '#a3a3a3',
                    ],
                ],
            ],
            'labels' => ['Success', 'Warning', 'Cancel', 'Off', 'Pending'],
        ];
    }

    protected function getType(): string
    {
        return 'pie';
    }
}
