<?php

namespace App\Filament\Exports;

use App\Models\RepairInspection;
use Filament\Actions\Exports\ExportColumn;
use Filament\Actions\Exports\Exporter;
use Filament\Actions\Exports\Models\Export;
use Illuminate\Support\Number;

class RepairInspectionExporter extends Exporter
{
    protected static ?string $model = RepairInspection::class;

    public static function getColumns(): array
    {
        return [
            ExportColumn::make('id')->label('ID'),
            ExportColumn::make('date_of_entry'),
            ExportColumn::make('mounth_of_entry'),
            ExportColumn::make('date_of_exit'),
            ExportColumn::make('mounth_of_exit'),
            ExportColumn::make('unit.name'),
            ExportColumn::make('serial_number_unit_gas_detector'),
            ExportColumn::make('type_firm_wire'),
            ExportColumn::make('old_serial_number_censor'),
            ExportColumn::make('new_serial_number_censor'),
            ExportColumn::make('old_serial_number_pcb'),
            ExportColumn::make('new_serial_number_pcb'),
            ExportColumn::make('old_serial_number_battery'),
            ExportColumn::make('new_serial_number_battery'),
            ExportColumn::make('date_of_purchase'),
            ExportColumn::make('customer.name'),
            ExportColumn::make('warranty_start_date'),
            ExportColumn::make('warranty_end_date'),
            ExportColumn::make('so'),
            ExportColumn::make('warranty_claim'),
            ExportColumn::make('number_certificate'),
            ExportColumn::make('comment'),
            ExportColumn::make('status'),
            ExportColumn::make('status_penawaran'),
            ExportColumn::make('created_at'),
            ExportColumn::make('updated_at'),
        ];
    }

    public static function getCompletedNotificationBody(Export $export): string
    {
        $body = 'Your repair inspection export has completed and ' . Number::format($export->successful_rows) . ' ' . str('row')->plural($export->successful_rows) . ' exported.';

        if ($failedRowsCount = $export->getFailedRowsCount()) {
            $body .= ' ' . Number::format($failedRowsCount) . ' ' . str('row')->plural($failedRowsCount) . ' failed to export.';
        }

        return $body;
    }
}
