<?php

namespace App\Http\Controllers;

use App\Models\RepairInspection;
use Illuminate\Http\Request;
use Carbon\Carbon;

class GuestHistoryController extends Controller
{
    public function index(Request $request)
    {
        $serialNumber = $request->get('serial_number');
        $results = [];

        if ($serialNumber) {
            $results = RepairInspection::with(['unit', 'customer'])
                ->where('serial_number_unit_gas_detector', 'like', '%' . $serialNumber . '%')
                ->whereNotNull('date_of_exit')
                ->orderBy('date_of_exit', 'desc')
                ->get();
        }

        return view('guest.history', [
            'serialNumber' => $serialNumber,
            'results' => $results,
        ]);
    }
}




