<?php

namespace App\Http\Controllers;

use App\Models\RepairInspection;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class NotificationController extends Controller
{
    /**
     * Handle edit action from notification
     * This will mark the notification as read and redirect to the edit page
     */
    public function editFromNotification(Request $request, RepairInspection $repairInspection)
    {
        $user = Auth::user();
        
        if (!$user) {
            return redirect()->route('filament.admin.auth.login');
        }
        
        // Debug: Log the notification marking process
        Log::info('Marking notifications as read for user: ' . $user->id . ', repair inspection: ' . $repairInspection->id);
        
        // Get all unread notifications for this user and type
        $notifications = DB::table('notifications')
            ->where('notifiable_type', get_class($user))
            ->where('notifiable_id', $user->id)
            ->where('type', 'App\Notifications\RepairInspectionReminder')
            ->whereNull('read_at')
            ->get();
        
        Log::info('Found ' . $notifications->count() . ' unread notifications for user ' . $user->id);
        Log::info('Looking for repair_inspection_id: ' . $repairInspection->id);
        
        $updatedCount = 0;
        
        // Filter and update notifications that match the repair inspection ID
        foreach ($notifications as $notification) {
            $data = json_decode($notification->data, true);
            Log::info('Checking notification ID: ' . $notification->id . ', data: ' . json_encode($data));
            
            if (isset($data['repair_inspection_id']) && $data['repair_inspection_id'] == $repairInspection->id) {
                Log::info('Match found! Updating notification ID: ' . $notification->id);
                DB::table('notifications')
                    ->where('id', $notification->id)
                    ->update(['read_at' => now()]);
                $updatedCount++;
            }
        }
        
        Log::info('Updated ' . $updatedCount . ' notifications as read');
        
        // Redirect directly to the edit URL
        return redirect()->to("/repair-inspections/{$repairInspection->id}/edit");
    }
}
