<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class MarkRepairInspectionNotificationAsRead
{
    public function handle(Request $request, Closure $next)
    {
        $user = Auth::user();

        if ($user) {
            // Resolve the repair inspection id from route or query
            $repairInspectionId = $request->route('record')
                ?? $request->route('repairInspection')
                ?? $request->query('repairInspection')
                ?? $request->query('ri');

            if ($repairInspectionId) {
                // Mark matching unread notifications as read
                $notifications = DB::table('notifications')
                    ->where('notifiable_type', get_class($user))
                    ->where('notifiable_id', $user->id)
                    ->whereNull('read_at')
                    ->get();

                foreach ($notifications as $notification) {
                    $data = json_decode($notification->data, true);

                    $matchesById = isset($data['repair_inspection_id'])
                        && (string) $data['repair_inspection_id'] === (string) $repairInspectionId;

                    $matchesByActionUrl = false;
                    if (isset($data['actions']) && is_array($data['actions'])) {
                        foreach ($data['actions'] as $action) {
                            $url = $action['url'] ?? null;
                            if (is_string($url) && str_contains($url, "/repair-inspections/{$repairInspectionId}/edit")) {
                                $matchesByActionUrl = true;
                                break;
                            }
                        }
                    }

                    if ($matchesById || $matchesByActionUrl) {
                        DB::table('notifications')
                            ->where('id', $notification->id)
                            ->update(['read_at' => now()]);
                    }
                }
            }
        }

        return $next($request);
    }
}


