<?php

namespace App\Notifications;

use App\Models\RepairInspection;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification as LaravelNotification;

class PendingRepairInspectionReminder extends LaravelNotification
{
    use Queueable;

    protected $repairInspection;
    protected $daysPending;

    public function __construct(RepairInspection $repairInspection, int $daysPending)
    {
        $this->repairInspection = $repairInspection;
        $this->daysPending = $daysPending;
    }

    public function via(object $notifiable): array
    {
        return ['database'];
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'type' => 'pending_overdue',
            'repair_inspection_id' => $this->repairInspection->id,
            'number_certificate' => $this->repairInspection->number_certificate,
            'customer_id' => $this->repairInspection->customer->id ?? null,
            'customer_name' => $this->repairInspection->customer->name ?? 'Unknown',
            'date_of_entry' => optional($this->repairInspection->date_of_entry)->format('Y-m-d'),
            'days_pending' => $this->daysPending,
            'title' => 'Reminder: Pending Over 7 Days',
            'body' => "{$this->repairInspection->customer->name} • #{$this->repairInspection->number_certificate} • Pending for {$this->daysPending} days",
            'color' => 'warning',
            'icon' => 'heroicon-o-clock',
        ];
    }
}





