<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('repair_inspections', function (Blueprint $table) {
            $table->id();
            $table->date("date_of_entry");
            $table->string("mounth_of_entry")->nullable();
            $table->date("date_of_exit");
            $table->string("mounth_of_exit")->nullable();
            $table->foreignId("unit_id")->constrained()->cascadeOnDelete();
            $table->string("serial_number_unit_gas_detector");
            $table->string("type_firm_wire")->nullable();
            $table->string("old_serial_number_censor")->nullable();
            $table->string("new_serial_number_censor")->nullable();
            $table->string("old_serial_number_pcb")->nullable();
            $table->string("new_serial_number_pcb")->nullable();
            $table->string("old_serial_number_battery")->nullable();
            $table->string("new_serial_number_battery")->nullable();
            $table->string("date_of_purchase")->nullable();
            $table->foreignId("customer_id")->constrained()->cascadeOnDelete();
            $table->string("warranty_start_date")->nullable();
            $table->string("warranty_end_date")->nullable();
            $table->string("so")->nullable();
            $table->string("warranty_claim")->nullable();
            $table->string("number_certificate")->nullable();
            $table->string("comment")->nullable();
            $table->enum("status", ["success", "warning", "cancel", "off"])->nullable();
            $table->string("status_penawaran")->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('repair_inspections');
    }
};
