<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('repair_inspections', function (Blueprint $table) {
            $table->enum('reminder_period', ['6_months', '1_year', '2_years', '6_years'])->nullable()->after('status_penawaran');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('repair_inspections', function (Blueprint $table) {
            $table->dropColumn('reminder_period');
        });
    }
};
