<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('repair_inspections', function (Blueprint $table) {
            $table->enum("type", [
                "calibration",
                "replacement",
                "replacement_and_calibration",
                "new_and_calibration"
            ])->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('repair_inspection', function (Blueprint $table) {
            $table->dropColumn("type");
        });
    }
};
