<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\RepairInspection;
use App\Models\Customer;
use App\Models\Unit;
use Carbon\Carbon;

class RepairInspectionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // RepairInspection::truncate();
        // Customer::truncate();
        // Unit::truncate();
        $repairData = [
            [
                "No" => "-",
                "Date of Entry goods" => "2-Jan-23",
                "Mounth of entry goods" => "Januari",
                "Date of Exit goods" => "24-Jan-23",
                "months out goods" => "Januari",
                "Unit" => "Gamax XT",
                "Serial Number Unit Gas Detektor" => "MA215-030225",
                "Type Firm Wire" => "FW_13_000",
                "old Serial Number Sensor" => "",
                "New Serial Number Sensor" => "",
                "old Serial Number Pcb" => "",
                "New Serial Number Pcb" => "",
                "old Serial Number Battery" => "",
                "New Serial Number Battery" => "",
                "PO-Date of Purchase" => "PO/2015",
                "Customer-PO-Date of PO" => "PT KPJB-PLTU Tanjung Jati - Jepara PO. 34/PR223000080",
                "1st Warranty Start Date" => "24-Jan-23",
                "1st Warranty End Date" => "23-Jul-23",
                "SO#" => "",
                "Warranty claim" => "Calibration unit",
                "Number Certificate" => "6491/CTR/AL/I/2023",
                "Coment" => "LCD (pinjam) Ok",
                "Status Penawaran" => ""
            ],
            [
                "No" => "-",
                "Date of Entry goods" => "2-Jan-23",
                "Mounth of entry goods" => "Januari",
                "Date of Exit goods" => "24-Jan-23",
                "months out goods" => "Januari",
                "Unit" => "",
                "Serial Number Unit Gas Detektor" => "q234fsdf",
                "Type Firm Wire" => "",
                "old Serial Number Sensor" => "",
                "New Serial Number Sensor" => "",
                "old Serial Number Pcb" => "",
                "New Serial Number Pcb" => "",
                "old Serial Number Battery" => "",
                "New Serial Number Battery" => "",
                "PO-Date of Purchase" => "PO/2015",
                "Customer-PO-Date of PO" => "PT KPJB-PLTU Tanjung Jati - Jepara PO. 34/PR223000080",
                "1st Warranty Start Date" => "24-Jan-23",
                "1st Warranty End Date" => "23-Jan-24",
                "SO#" => "",
                "Warranty claim" => "O2 sensor",
                "Number Certificate" => "",
                "Coment" => "OK",
                "Status Penawaran" => ""
            ],
            [
                "No" => "-",
                "Date of Entry goods" => "2-Jan-23",
                "Mounth of entry goods" => "Januari",
                "Date of Exit goods" => "24-Jan-23",
                "months out goods" => "Januari",
                "Unit" => "",
                "Serial Number Unit Gas Detektor" => "dsafadsadsgfds",
                "Type Firm Wire" => "",
                "old Serial Number Sensor" => "",
                "New Serial Number Sensor" => "",
                "old Serial Number Pcb" => "",
                "New Serial Number Pcb" => "",
                "old Serial Number Battery" => "",
                "New Serial Number Battery" => "",
                "PO-Date of Purchase" => "PO/2015",
                "Customer-PO-Date of PO" => "PT KPJB-PLTU Tanjung Jati - Jepara PO. 34/PR223000080",
                "1st Warranty Start Date" => "24-Jan-23",
                "1st Warranty End Date" => "23-Jul-23",
                "SO#" => "",
                "Warranty claim" => "Particulate pump filter",
                "Number Certificate" => "",
                "Coment" => "Ok",
                "Status Penawaran" => ""
            ],
            [
                "No" => "-",
                "Date of Entry goods" => "2-Jan-23",
                "Mounth of entry goods" => "Januari",
                "Date of Exit goods" => "24-Jan-23",
                "months out goods" => "Januari",
                "Unit" => "MicroClip",
                "Serial Number Unit Gas Detektor" => "KA419-1116301",
                "Type Firm Wire" => "FW 50 D",
                "old Serial Number Sensor" => "",
                "New Serial Number Sensor" => "",
                "old Serial Number Pcb" => "",
                "New Serial Number Pcb" => "",
                "old Serial Number Battery" => "",
                "New Serial Number Battery" => "",
                "PO-Date of Purchase" => "PO/2019",
                "Customer-PO-Date of PO" => "PT KPJB-PLTU Tanjung Jati - Jepara PO. 34/PR223000080",
                "1st Warranty Start Date" => "24-Jan-23",
                "1st Warranty End Date" => "23-Jul-23",
                "SO#" => "",
                "Warranty claim" => "Calibration unit",
                "Number Certificate" => "6492/CTR/AL/I/2023",
                "Coment" => "Ok",
                "Status Penawaran" => ""
            ],
            [
                "No" => "-",
                "Date of Entry goods" => "5-Jan-23",
                "Mounth of entry goods" => "Januari",
                "Date of Exit goods" => "5-Jan-23",
                "months out goods" => "Januari",
                "Unit" => "MicroClip",
                "Serial Number Unit Gas Detektor" => "KA422-1071077",
                "Type Firm Wire" => "FW 50 D",
                "old Serial Number Sensor" => "",
                "New Serial Number Sensor" => "",
                "old Serial Number Pcb" => "",
                "New Serial Number Pcb" => "",
                "old Serial Number Battery" => "",
                "New Serial Number Battery" => "",
                "PO-Date of Purchase" => "PO/2022",
                "Customer-PO-Date of PO" => "PT Sinergi Inti Perkasa. PO. 072/SIP-PO/XI/2022",
                "1st Warranty Start Date" => "5-Jan-23",
                "1st Warranty End Date" => "4-Jul-23",
                "SO#" => "",
                "Warranty claim" => "Calibration unit",
                "Number Certificate" => "6477/CTR/CN/I/2023",
                "Coment" => "Ok (unit baru) beli 16 November 2022",
                "Status Penawaran" => ""
            ],
        ];

        $createdUnits = [];
        $createdCustomers = [];

        foreach ($repairData as $index => $data) {
            $unit = null;
            if (!empty($data['Unit'])) {
                if (!isset($createdUnits[$data['Unit']])) {
                    $unit = Unit::firstOrCreate(['name' => $data['Unit']]);
                    $createdUnits[$data['Unit']] = $unit;
                } else {
                    $unit = $createdUnits[$data['Unit']];
                }
            } else {
                $defaultUnitName = 'Unknown Unit';
                if (!isset($createdUnits[$defaultUnitName])) {
                    $unit = Unit::firstOrCreate(['name' => $defaultUnitName]);
                    $createdUnits[$defaultUnitName] = $unit;
                } else {
                    $unit = $createdUnits[$defaultUnitName];
                }
            }

            $customer = null;
            $customerInfo = $this->parseCustomerInfo($data['Customer-PO-Date of PO']);
            
            if (!empty($customerInfo['name'])) {
                $customerKey = $customerInfo['name'] . '|' . $customerInfo['po_number'];
                if (!isset($createdCustomers[$customerKey])) {
                    $customer = Customer::firstOrCreate(
                        ['name' => $customerInfo['name'], 'po_number' => $customerInfo['po_number']], 
                        [
                            'name' => $customerInfo['name'],
                            'po_number' => $customerInfo['po_number'],
                            'date_of_po' => null, 
                        ]
                    );
                    $createdCustomers[$customerKey] = $customer;
                } else {
                    $customer = $createdCustomers[$customerKey];
                }
            } else {
                $defaultCustomerName = 'Unknown Customer';
                $defaultCustomerKey = $defaultCustomerName . '|';
                if (!isset($createdCustomers[$defaultCustomerKey])) {
                    $customer = Customer::firstOrCreate(
                        ['name' => $defaultCustomerName, 'po_number' => null],
                        [
                            'name' => $defaultCustomerName,
                            'po_number' => null,
                            'date_of_po' => null,
                        ]
                    );
                    $createdCustomers[$defaultCustomerKey] = $customer;
                } else {
                    $customer = $createdCustomers[$defaultCustomerKey];
                }
            }

            $serialNumber = !empty($data['Serial Number Unit Gas Detektor']) ? $data['Serial Number Unit Gas Detektor'] : null;

            $existingInspection = RepairInspection::where('serial_number_unit_gas_detector', $serialNumber)->first();
            
            if (!$existingInspection) {
                RepairInspection::create([
                'date_of_entry' => $this->parseDate($data['Date of Entry goods']),
                'mounth_of_entry' => $data['Mounth of entry goods'],
                'date_of_exit' => $this->parseDate($data['Date of Exit goods']),
                'mounth_of_exit' => $data['months out goods'],
                'unit_id' => $unit->id, 
                'serial_number_unit_gas_detector' => $serialNumber,
                'type_firm_wire' => $data['Type Firm Wire'] ?: null,
                'old_serial_number_censor' => $data['old Serial Number Sensor'] ?: null,
                'new_serial_number_censor' => $data['New Serial Number Sensor'] ?: null,
                'old_serial_number_pcb' => $data['old Serial Number Pcb'] ?: null,
                'new_serial_number_pcb' => $data['New Serial Number Pcb'] ?: null,
                'old_serial_number_battery' => $data['old Serial Number Battery'] ?: null,
                'new_serial_number_battery' => $data['New Serial Number Battery'] ?: null,
                'date_of_purchase' => $data['PO-Date of Purchase'] ?: null, 
                'customer_id' => $customer->id, 
                'warranty_start_date' => $this->parseDate($data['1st Warranty Start Date']),
                'warranty_end_date' => $this->parseDate($data['1st Warranty End Date']),
                'so' => $data['SO#'] ?: null,
                'warranty_claim' => $data['Warranty claim'] ?: null,
                'number_certificate' => $data['Number Certificate'] ?: null,
                'comment' => $data['Coment'] ?: null,
                // 'status' => null, // Comment out jika masih error
                'status_penawaran' => $data['Status Penawaran'] ?: null,
                'reminder_period' => null,
                ]);
            }
        }
    }

    private function parseCustomerInfo(string $customerPOInfo): array
    {
        if (empty($customerPOInfo)) {
            return ['name' => '', 'po_number' => ''];
        }

        $parts = explode(' PO. ', $customerPOInfo);
        
        $customerName = trim($parts[0]);
        $poNumber = isset($parts[1]) ? trim($parts[1]) : '';

        return [
            'name' => $customerName,
            'po_number' => $poNumber
        ];
    }

    private function parseDate(?string $dateString): ?string
    {
        if (empty($dateString) || $dateString === '') {
            return null;
        }

        try {
            $date = Carbon::createFromFormat('j-M-y', $dateString);
            return $date->format('Y-m-d');
        } catch (\Exception $e) {
            try {
                $date = Carbon::createFromFormat('d-M-y', $dateString);
                return $date->format('Y-m-d');
            } catch (\Exception $e2) {
                return null;
            }
        }
    }
}