<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>INVOICE KALIBRASI - {{ $repairInspection->number_certificate }}</title>
    <style>
        body {
            font-family: 'Arial', sans-serif;
            color: #222;
            padding: 36px 24px 24px 24px;
            font-size: 13px;
            background: #fff;
        }

        .header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            border-bottom: 2.5px solid #0954A2;
            padding-bottom: 14px;
            margin-bottom: 24px;
        }

        .company-info {
            font-size: 15px;
            font-weight: bold;
            color: #0954A2;
        }

        .company-details {
            font-size: 11px;
            margin-top: 2px;
            color: #444;
        }

        .invoice-title {
            text-align: center;
            font-size: 23px;
            font-weight: bold;
            color: #222;
            margin: 0 0 20px 0;
            letter-spacing: 1.4px;
        }

        .invoice-meta {
            display: flex;
            justify-content: space-between;
            margin-bottom: 12px;
        }

        .meta-block {
            font-size: 13px;
        }

        .meta-block span.label {
            font-weight: 600;
            color: #0954A2;
        }

        .address-block {
            font-size: 12px;
        }

        .flex-grid {
            display: flex;
            justify-content: space-between;
            margin-bottom: 18px;
        }

        .from-to {
            width: 49%;
            border: 1px solid #dbeafe;
            border-radius: 6px;
            padding: 11px 14px;
            background: #f5faff;
        }

        .from-to-title {
            font-weight: bold;
            color: #0954A2;
            margin-bottom: 6px;
            letter-spacing: 0.8px;
            font-size: 13px;
        }

        table.invoice-table {
            width: 100%;
            border-collapse: collapse;
            margin: 15px 0 17px 0;
        }

        table.invoice-table th {
            background: #0954A2;
            color: #fff;
            padding: 7px 5px;
            text-align: left;
            font-size: 13px;
        }

        table.invoice-table td {
            padding: 7px 5px;
            font-size: 13px;
            border-bottom: 1px solid #e5e7eb;
        }

        table.invoice-table tr:last-child td {
            border-bottom: none;
        }

        .right {
            text-align: right;
        }

        .bold {
            font-weight: bold;
        }

        .total-row th,
        .total-row td {
            font-size: 15px;
            background: #f0f5fe;
            font-weight: 600;
        }

        .note {
            margin: 17px 0 0 0;
            font-size: 12px;
            color: #6b7280;
        }

        .signature-area {
            margin-top: 38px;
            text-align: right;
        }

        .signature-area .sig-label {
            margin-bottom: 60px;
            display: inline-block;
        }

        .footer {
            position: fixed;
            bottom: 20px;
            left: 0;
            right: 0;
            font-size: 11px;
            text-align: center;
            color: #bababa;
        }

        @media print {
            body {
                padding: 0;
            }
        }
    </style>
</head>

<body>
    <!-- HEADER INVOICE -->
    <div class="header">
        <div>
            <img src="{{ public_path('images/logo-home.png') }}" alt="Logo" width="100px">
        </div>
        {{-- <div style="text-align:right"> --}}
        <span style="font-size:13px;">No. Cert :</span> <span
            style="font-weight:bold; font-size:14px">{{ $repairInspection->number_certificate ?? '-' }}</span><br>
        <span style="font-size:13px;">Tanggal :</span>
        <span>{{ $repairInspection->date_of_exit ? \Carbon\Carbon::parse($repairInspection->date_of_exit)->format('d F Y') : ($repairInspection->date_of_entry ? \Carbon\Carbon::parse($repairInspection->date_of_entry)->format('d F Y') : '-') }}</span>
        {{-- </div> --}}
    </div>

    <!-- RINCIAN PEKERJAAN KALIBRASI -->
    <table class="invoice-table">
        <thead>
            <tr>
                <th style="width:47%;">Deskripsi Pekerjaan</th>
                <th style="width:28%;">Serial Number</th>
                <th style="width:11%;">Catatan</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td>Kalibrasi Gas Detector - {{ $repairInspection->unit->name ?? '-' }}<br>
                    <span style="font-size:11px; color:#777">
                        Tipe: {{ $repairInspection->type_firm_wire ?? '-' }}, Unit:
                        {{ $repairInspection->unit->name ?? '-' }}
                    </span>
                </td>
                <td>{{ $repairInspection->serial_number_unit_gas_detector ?? '-' }}</td>
                <td>{{ $repairInspection->comment ?? '-' }}</td>
            </tr>
        </tbody>
    </table>
    <table style="width:100%; margin-bottom: 19px; font-size:12px;">
        <tr>
            <td style="width:32%;">Tanggal Masuk</td>
            <td>:
                {{ $repairInspection->date_of_entry ? \Carbon\Carbon::parse($repairInspection->date_of_entry)->format('d F Y') : '-' }}
            </td>
        </tr>
        <tr>
            <td>Tanggal Keluar</td>
            <td>:
                {{ $repairInspection->date_of_exit ? \Carbon\Carbon::parse($repairInspection->date_of_exit)->format('d F Y') : '-' }}
            </td>
        </tr>
        <tr>
            <td>No. PO</td>
            <td>: {{ $repairInspection->no_po ?? '-' }}</td>
        </tr>
        <tr>
            <td>SO#</td>
            <td>: {{ $repairInspection->so ?? '-' }}</td>
        </tr>
        <tr>
            <td>No. Sertifikat</td>
            <td>: {{ $repairInspection->number_certificate ?? '-' }}</td>
        </tr>
        <tr>
            <td>Klaim Garansi</td>
            <td>: {{ $repairInspection->warranty_claim ?? '-' }}</td>
        </tr>
        <tr>
            <td>Garansi</td>
            <td>:
                {{ $repairInspection->warranty_start_date ? \Carbon\Carbon::parse($repairInspection->warranty_start_date)->format('d F Y') : '-' }}
                s/d
                {{ $repairInspection->warranty_end_date ? \Carbon\Carbon::parse($repairInspection->warranty_end_date)->format('d F Y') : '-' }}
            </td>
        </tr>
        <tr>
            <td>Status</td>
            <td>: {{ ucfirst($repairInspection->status ?? '-') }}</td>
        </tr>
    </table>

    <div class="footer">
        Invoice generated by system - {{ now()->format('d F Y, H:i') }}<br>
    </div>
</body>

</html>
