<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Repair Inspection - <?php echo e($repairInspection->number_certificate); ?></title>
    <style>
        body {
            font-family: 'Times New Roman', Times, serif;
            color: #222;
            font-size: 14px;
            line-height: 1.5;
            margin: 32px;
        }

        .heading {
            text-align: center;
            margin-bottom: 18px;
        }

        .heading h1 {
            font-size: 16px;
            margin: 0;
        }

        .heading h2 {
            font-size: 13px;
            font-weight: normal;
            margin: 6px 0 0 0;
            color: #444;
        }

        .meta {
            margin: 18px 0;
        }

        .meta .row {
            display: flex;
            /* align-items: baseline; */
            justify-content: space-between;
            gap: 12px;
            margin: 4px 0;
        }

        .label {
            color: #666;
            font-size: 12px;
        }

        .label::after {
            content: ":";
            margin-left: 2px;
        }

        .value {
            text-align: right;
            font-weight: bold;
            word-break: break-word;
        }

        .section-title {
            margin: 18px 0 6px 0;
            font-weight: bold;
            text-transform: uppercase;
            font-size: 11px;
            color: #444;
        }

        .hr {
            border-top: 1px solid #ccc;
            margin: 14px 0;
        }

        .sign {
            margin-top: 46px;
            display: flex;
            justify-content: start;
        }

        .sign .box {
            width: 45%;
            text-align: center;
        }

        .muted {
            color: #666;
        }
    </style>
</head>

<body>
    <div style="text-align:right;" class="muted"><?php echo e(now()->format('d F Y')); ?></div>
    <div class="heading">
        <h1>Laporan Hasil Kalibrasi</h1>
        <h2>Certificate: <?php echo e($repairInspection->number_certificate ?? '-'); ?></h2>
    </div>

    <div class="section">
        <div class="section-title">Summary</div>
        <div class="meta">
            <div class="row">
                <div class="label">Customer</div>
                <div class="value"><?php echo e($repairInspection->customer->name ?? 'N/A'); ?></div>
            </div>
            <div class="row">
                <div class="label">Unit</div>
                <div class="value"><?php echo e($repairInspection->unit->name ?? ($repairInspection->unit ?? 'N/A')); ?></div>
            </div>
            <div class="row">
                <div class="label">Serial Number</div>
                <div class="value">
                    <?php echo e($repairInspection->serial_number_unit_gas_detector ?? ($repairInspection->type_firm_ware ?? 'N/A')); ?>

                </div>
            </div>
            <div class="row">
                <div class="label">Status</div>
                <div class="value"><?php echo e($repairInspection->status ?? 'N/A'); ?></div>
            </div>
        </div>
    </div>

    <div class="section">
        <div class="section-title">Rincian Perangkat</div>
        <div class="meta">
            <div class="row">
                <div class="label">Type Firmware</div>
                <div class="value">
                    <?php echo e($repairInspection->type_firm_ware ?? ($repairInspection->type_firm_wire ?? 'N/A')); ?></div>
            </div>
            <div class="row">
                <div class="label">Old Serial Number Sensor</div>
                <div class="value"><?php echo e($repairInspection->old_serial_number_censor ?? 'N/A'); ?></div>
            </div>
            <div class="row">
                <div class="label">New Serial Number Sensor</div>
                <div class="value"><?php echo e($repairInspection->new_serial_number_censor ?? 'N/A'); ?></div>
            </div>
            <div class="row">
                <div class="label">Old Serial Number PCB</div>
                <div class="value"><?php echo e($repairInspection->old_serial_number_pcb ?? 'N/A'); ?></div>
            </div>
            <div class="row">
                <div class="label">New Serial Number PCB</div>
                <div class="value"><?php echo e($repairInspection->new_serial_number_pcb ?? 'N/A'); ?></div>
            </div>
            <div class="row">
                <div class="label">Old Serial Number Battery</div>
                <div class="value"><?php echo e($repairInspection->old_serial_number_battery ?? 'N/A'); ?></div>
            </div>
            <div class="row">
                <div class="label">New Serial Number Battery</div>
                <div class="value"><?php echo e($repairInspection->new_serial_number_battery ?? 'N/A'); ?></div>
            </div>
            <div class="row">
                <div class="label">Date of Purchase</div>
                <div class="value"><?php echo e($repairInspection->date_of_purchase ?? 'N/A'); ?></div>
            </div>
        </div>
    </div>

    <div class="section">
        <div class="section-title">Dates</div>
        <div class="meta">
            <div class="row">
                <div class="label">Date of Entry</div>
                <div class="value"><?php echo e(optional($repairInspection->date_of_entry)->format('d F Y') ?? 'N/A'); ?></div>
            </div>
            <div class="row">
                <div class="label">Date of Exit</div>
                <div class="value"><?php echo e(optional($repairInspection->date_of_exit)->format('d F Y') ?? 'N/A'); ?></div>
            </div>
        </div>
    </div>

    <div class="section">
        <div class="section-title">Notes</div>
        <div class="meta">
            <div class="row">
                <div class="label">Warranty Claim</div>
                <div class="value"><?php echo e($repairInspection->warranty_claim ?? '-'); ?></div>
            </div>
            <div class="row">
                <div class="label">Comment</div>
                <div class="value"><?php echo e($repairInspection->comment ?? '-'); ?></div>
            </div>
        </div>
    </div>

    <div class="hr"></div>

    <div class="sign">
        <div class="box">
            <div class="muted">Dibuat Oleh</div>
            <div style="height:60px;"></div>
            <div><strong><?php echo e($repairInspection->name ?? '-'); ?></strong></div>
        </div>
        <div class="box">
            <div class="muted">Teknikal</div>
            <div style="height:60px;"></div>
            <div><strong>&nbsp;</strong></div>
        </div>
    </div>

    <div class="hr"></div>
    <div class="muted" style="text-align:center;">Generated by Repair Inspection System ·
        <?php echo e(now()->format('d F Y, H:i')); ?></div>
</body>

</html>
<?php /**PATH E:\Projects\work\calibrate_apd\resources\views/pdf/repair-inspection-simple.blade.php ENDPATH**/ ?>