<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Riwayat - Berkat Safety</title>
    <link rel="icon" type="image/x-icon" href="<?php echo e(asset('images/favicon.png')); ?>">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
            min-height: 100vh;
            padding: 20px;
        }

        .container {
            max-width: 1000px;
            margin: 0 auto;
        }

        .header {
            display: flex;
            align-items: center;
            gap: 12px;
            margin-bottom: 40px;
        }

        .main-card {
            background: white;
            border-radius: 16px;
            padding: 40px;
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.1);
            margin-bottom: 40px;
        }

        .search-section {
            margin-bottom: 40px;
        }

        .search-label {
            color: #666;
            font-size: 14px;
            margin-bottom: 12px;
            display: block;
        }

        .search-form {
            display: flex;
            gap: 12px;
        }

        .search-input {
            flex: 1;
            padding: 14px 18px;
            border: 2px solid #e5e7eb;
            border-radius: 10px;
            font-size: 16px;
            outline: none;
            transition: all 0.2s;
        }

        .search-input:focus {
            border-color: #012367;
            box-shadow: 0 0 0 3px rgba(30, 64, 175, 0.1);
        }

        .search-button {
            background: #012367;
            color: white;
            border: none;
            padding: 14px 32px;
            border-radius: 10px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.2s;
        }

        .search-button:hover {
            background: #1e3a8a;
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(30, 64, 175, 0.3);
        }

        .search-button:active {
            transform: translateY(0);
        }

        .results-section {
            margin-top: 40px;
        }

        .result-item {
            display: grid;
            grid-template-columns: 1fr auto;
            gap: 20px;
            padding: 24px 0;
        }

        .result-number {
            width: 32px;
            height: 32px;
            background: #012367;
            color: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 600;
            font-size: 14px;
            flex-shrink: 0;
        }

        .result-content {
            display: flex;
            flex-direction: column;
            gap: 16px;
        }

        .result-header {
            padding-bottom: 16px;
            border-bottom: 2px dashed #d1d5db;
        }

        .product-name {
            font-size: 20px;
            font-weight: 700;
            color: #111;
            margin-bottom: 4px;
        }

        .serial-number {
            font-size: 16px;
            color: #9FCC47;
            font-weight: 600;
        }

        .result-fields {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 16px;
        }

        .result-field {
            display: flex;
            flex-direction: column;
            gap: 4px;
        }

        .result-label {
            font-size: 14px;
            color: #666;
        }

        .result-value {
            font-size: 18px;
            font-weight: 600;
            color: #111;
        }

        .decorative-circles {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: -1;
            pointer-events: none;
        }

        .circle-row {
            display: flex;
            gap: 15px;
            margin-bottom: 15px;
            justify-content: flex-end;
        }

        .circle {
            border-radius: 50%;
            opacity: 0.2;
        }

        /* Row 1 - 5 circles */
        .circle-row:nth-child(1) .circle:nth-child(1) {
            width: 12px;
            height: 12px;
            background: #9FCC47;
        }

        .circle-row:nth-child(1) .circle:nth-child(2) {
            width: 12px;
            height: 12px;
            background: #2C3E7A;
        }

        .circle-row:nth-child(1) .circle:nth-child(3) {
            width: 12px;
            height: 12px;
            background: #012367;
        }

        .circle-row:nth-child(1) .circle:nth-child(4) {
            width: 12px;
            height: 12px;
            background: #9FCC47;
        }

        .circle-row:nth-child(1) .circle:nth-child(5) {
            width: 12px;
            height: 12px;
            background: #2C3E7A;
        }

        /* Row 2 - 4 circles */
        .circle-row:nth-child(2) .circle:nth-child(1) {
            width: 10px;
            height: 10px;
            background: #2C3E7A;
        }

        .circle-row:nth-child(2) .circle:nth-child(2) {
            width: 10px;
            height: 10px;
            background: #9FCC47;
        }

        .circle-row:nth-child(2) .circle:nth-child(3) {
            width: 10px;
            height: 10px;
            background: #012367;
        }

        .circle-row:nth-child(2) .circle:nth-child(4) {
            width: 10px;
            height: 10px;
            background: #2C3E7A;
        }

        /* Row 3 - 3 circles */
        .circle-row:nth-child(3) .circle:nth-child(1) {
            width: 8px;
            height: 8px;
            background: #9FCC47;
        }

        .circle-row:nth-child(3) .circle:nth-child(2) {
            width: 8px;
            height: 8px;
            background: #012367;
        }

        .circle-row:nth-child(3) .circle:nth-child(3) {
            width: 8px;
            height: 8px;
            background: #2C3E7A;
        }

        .status-badge {
            display: inline-block;
            padding: 4px 12px;
            border-radius: 6px;
            font-size: 13px;
            font-weight: 600;
        }

        .status-success {
            background: #dcfce7;
            color: #166534;
        }

        .status-warning {
            background: #fef3c7;
            color: #92400e;
        }

        .status-cancel {
            background: #fee2e2;
            color: #991b1b;
        }

        .status-off {
            background: #f3f4f6;
            color: #374151;
        }

        .no-results {
            text-align: center;
            padding: 60px 20px;
            color: #666;
        }

        .no-results-icon {
            font-size: 48px;
        }

        .no-results-text {
            font-size: 20px;
        }

        .decorative-shapes {
            position: fixed;
            bottom: 0;
            left: 0;
            width: 200px;
            height: 200px;
            z-index: -1;
            pointer-events: none;
        }

        .shape-green {
            position: absolute;
            bottom: 150px;
            left: 0;
            width: 0;
            height: 0;
            border-left: 140px solid #9FCC47;
            border-bottom: 150px solid transparent;
            z-index: -3;
            /* border-radius: 30% 70% 70% 30% / 30% 30% 70% 70%; */
            /* opacity: 0.3; */
        }

        .shape-green {
            position: absolute;
            bottom: 150px;
            left: 0;
            width: 0;
            height: 0;
            border-left: 150px solid #9FCC47;
            border-top: 150px solid transparent;
            z-index: -3;
            /* border-radius: 30% 70% 70% 30% / 30% 30% 70% 70%; */
            /* opacity: 0.3; */
        }

        .shape-blue {
            position: absolute;
            bottom: 0;
            left: 0;
            width: 0;
            height: 0;
            border-left: 300px solid #2C3E7A;
            border-top: 250px solid transparent;
            z-index: -2;
            /* border-radius: 70% 30% 30% 70% / 70% 70% 30% 30%; */
            /* opacity: 0.3; */
        }

        input::placeholder {
            font-size: 16px;
            color: #b3b3b3;
        }

        @media (max-width: 768px) {
            .main-card {
                padding: 24px;
            }

            .search-form {
                flex-direction: column;
            }

            .result-fields {
                grid-template-columns: 1fr;
            }

            .result-item {
                grid-template-columns: 1fr;
            }

            .result-number {
                order: -1;
                display: none;
            }
        }
    </style>
</head>

<body>
    <div class="container">
        <div class="header">
            <img src="<?php echo e(asset('images/logo-home.png')); ?>" alt="Berkat Safety" class="logo-image" width="160px">
        </div>

        <div class="main-card">
            <div class="search-section">
                <label class="search-label">*Masukan serial number untuk melihat riwayat</label>
                <form action="<?php echo e(route('guest.history')); ?>" method="GET" class="search-form">
                    <input type="text" name="serial_number" class="search-input" placeholder="KA21-M1XXXXXX"
                        value="<?php echo e($serialNumber ?? ''); ?>" required>
                    <button type="submit" class="search-button">Lihat Riwayat</button>
                </form>
            </div>

            <?php if(request()->has('serial_number')): ?>
                <div class="results-section">
                    <?php if($results->count() > 0): ?>
                        <?php $__currentLoopData = $results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="result-item">
                                <div class="result-content">
                                    <div class="result-header">
                                        <div class="product-name"><?php echo e($result->unit->name ?? 'N/A'); ?></div>
                                        <div class="serial-number"><?php echo e($result->serial_number_unit_gas_detector); ?></div>
                                    </div>

                                    <div class="result-fields">
                                        <div class="result-field">
                                            <span class="result-label">Nomor Sertifikat:</span>
                                            <span class="result-value"><?php echo e($result->number_certificate ?? '-'); ?></span>
                                        </div>
                                        <div class="result-field">
                                            <span class="result-label">Nomor PO:</span>
                                            <span class="result-value"><?php echo e($result->no_po ?? '-'); ?></span>
                                        </div>
                                        <div class="result-field">
                                            <span class="result-label">Status PO:</span>
                                            <span class="result-value">
                                                <?php if($result->status): ?>
                                                    <span class="status-badge status-<?php echo e($result->status); ?>">
                                                        <?php echo e(ucfirst($result->status)); ?>

                                                    </span>
                                                <?php else: ?>
                                                    -
                                                <?php endif; ?>
                                            </span>
                                        </div>
                                        <div class="result-field">
                                            <span class="result-label">Tanggal Keluar:</span>
                                            <span class="result-value">
                                                <?php if($result->date_of_exit): ?>
                                                    <?php
                                                        $date = \Carbon\Carbon::parse($result->date_of_exit);
                                                        $months = [
                                                            1 => 'Januari',
                                                            2 => 'Februari',
                                                            3 => 'Maret',
                                                            4 => 'April',
                                                            5 => 'Mei',
                                                            6 => 'Juni',
                                                            7 => 'Juli',
                                                            8 => 'Agustus',
                                                            9 => 'September',
                                                            10 => 'Oktober',
                                                            11 => 'November',
                                                            12 => 'Desember',
                                                        ];
                                                        echo $date->day .
                                                            ' ' .
                                                            $months[$date->month] .
                                                            ' ' .
                                                            $date->year;
                                                    ?>
                                                <?php else: ?>
                                                    -
                                                <?php endif; ?>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                <div class="result-number"><?php echo e($index + 1); ?></div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <div class="no-results">
                            <div class="no-results-icon">
                                <img src="<?php echo e(asset('images/no-result.png')); ?>" alt="No Results" width="200px">
                            </div>
                            <div class="no-results-text">Tidak ada riwayat ditemukan untuk serial number ini.</div>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <div class="decorative-shapes">
        <div class="shape-green"></div>
        <div class="shape-blue"></div>
    </div>

    <div class="decorative-circles">
        <div class="circle-row">
            <div class="circle"></div>
            <div class="circle"></div>
            <div class="circle"></div>
            <div class="circle"></div>
            <div class="circle"></div>
        </div>
        <div class="circle-row">
            <div class="circle"></div>
            <div class="circle"></div>
            <div class="circle"></div>
            <div class="circle"></div>
        </div>
        <div class="circle-row">
            <div class="circle"></div>
            <div class="circle"></div>
            <div class="circle"></div>
        </div>
    </div>
</body>

</html>
<?php /**PATH E:\Projects\work\calibrate_apd\resources\views/guest/history.blade.php ENDPATH**/ ?>